<?php session_start(); 
require_once 'config.php'; ?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Blog - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link
        href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    
    <?php include 'header.php'; ?>
    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
        <div class="container z-index-common">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title">blog </h1>
            </div>
            <div class="breadcumb-menu-wrap">
                <ul class="breadcumb-menu">
                    <li><a href="index.php">Home</a></li>
                    <li>our blog</li>
                </ul>
            </div>
        </div>
    </div>
    <!--==============================
    Blog Area
    ==============================-->
    <section class="vs-blog__layout1 space" style="background-image:url('assets/img/bg/blog-bg1.png');">
    <style>
        .vs-blog__style1 {
    background: #fff;
    border-radius: 14px;
    overflow: hidden;
    height: 100%;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    transition: 0.3s ease;
}

.vs-blog__style1:hover {
    transform: translateY(-6px);
}

.blog-img {
    position: relative;
}

.blog-img img {
    width: 100%;
    height: 230px;
    object-fit: cover;
}

.blog-cate {
  position: absolute;
  top: 190px;
  background-color: var(--theme-color);
  left: 0;
  font-weight: 700;
  font-size: 15px;
  line-height: initial;
  color: var(--white-color);
  padding: 12px 40px 12px 22px;
  letter-spacing: 1px;
  text-transform: uppercase;
  transition: all 0.5s ease;
  clip-path: polygon(0 0, 80% 0%, 100% 100%, 0% 100%);
  z-index: 1;
}

.blog-content {
    padding: 20px;
}

.blog-meta {
    display: flex;
    gap: 15px;
    font-size: 13px;
    color: #777;
    margin-bottom: 8px;
}

.blog-title {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 12px;
}

.blog-title a {
    color: #222;
    text-decoration: none;
}

.link-btn {
    font-size: 14px;
    font-weight: 500;
    color: #1e88e5;
    text-decoration: none;
}

.link-btn i {
    margin-left: 5px;
}

/* Tablet */
@media (max-width: 991px) {
    .blog-img img {
        height: 210px;
    }
}

/* Mobile */
@media (max-width: 576px) {
    .blog-img img {
        height: 190px;
    }

    .blog-title {
        font-size: 16px;
    }

    .blog-meta {
        flex-direction: column;
        gap: 4px;
    }
}

    </style>
        <div class="container">

        <!-- Section Title -->
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8">
                <div class="title-area text-center">
                    <span class="sec-subtitle">OUR LATEST BLOG</span>
                    <h2 class="sec-title">Latest News & Updates</h2>
                </div>
            </div>
        </div>

        <!-- Blog Grid -->
        <div class="row g-4">
        <?php
        // Fetch blog posts from database
        $query = "SELECT id, title, category, content, featured_image, created_at, status FROM blog_posts WHERE status = 'published' ORDER BY created_at DESC LIMIT 4";
        $result = $conn->query($query);

        // Fallback blog posts if database is empty
        $fallback_blogs = array(
            array('id' => 1, 'title' => 'Launching Our Premium Room Cleaning Service', 'category' => 'Bedroom', 'content' => 'Discover our premium bedroom cleaning services', 'featured_image' => 'assets/img/blog/blog-s-3-1.jpg', 'created_at' => '2024-04-27'),
            array('id' => 2, 'title' => 'Cleaning Services That Match Your Lifestyle', 'category' => 'apartment', 'content' => 'Find the perfect apartment cleaning solution', 'featured_image' => 'assets/img/blog/blog-s-3-2.jpg', 'created_at' => '2024-04-27'),
            array('id' => 3, 'title' => 'Meet Our Professional House Cleaning Experts', 'category' => 'Home Care', 'content' => 'Learn about our team of cleaning professionals', 'featured_image' => 'assets/img/blog/blog-s-3-3.jpg', 'created_at' => '2024-04-27'),
            array('id' => 4, 'title' => 'Exclusive Offer: Get 10% Off on Cleaning', 'category' => 'Offers', 'content' => 'Limited time offer for all our cleaning services', 'featured_image' => 'assets/img/blog/blog-s-3-4.jpg', 'created_at' => '2024-04-27'),
        );

        // Use database results or fallback
        if ($result && $result->num_rows > 0) {
            $blogs = array();
            while ($row = $result->fetch_assoc()) {
                $blogs[] = $row;
            }
        } else {
            $blogs = $fallback_blogs;
        }

        // Display blog posts
        foreach ($blogs as $blog):
        ?>
            <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12">
                <div class="vs-blog__style1">
                    <div class="blog-img">
                        <a href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>">
                            <img src="<?php echo htmlspecialchars($blog['featured_image']); ?>" alt="<?php echo htmlspecialchars($blog['title']); ?>">
                        </a>
                        <span class="blog-cate"><?php echo htmlspecialchars($blog['category']); ?></span>
                    </div>

                    <div class="blog-content">
                        <div class="blog-meta">
                            <span><i class="fa-regular fa-calendar-days"></i> <?php echo date('F d, Y', strtotime($blog['created_at'])); ?></span>
                            <span><i class="far fa-comments"></i> 0 Comments</span>
                        </div>
                        <h3 class="blog-title">
                            <a href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>"><?php echo htmlspecialchars($blog['title']); ?></a>
                        </h3>
                        <a class="link-btn" href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>">
                            Read More <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>

        </div>
    </div>
</section>
<?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>